@extends('partials.main')
@section('title')
    {{ 'TOUR PACKAGES' }}
@endsection
@section('content')
    <style>
        .tg-description span {
            color: #ff7550;
        }

        .tg-populartourtitle {
            width: 100%;
            float: left;
            height: 48px;
            padding: 0 0 20px;
        }

        .tg-description {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            max-height: 20.4em;
        }

        .mask {
            mask-image: url('images/frame-design.svg');

            mask-mode: alpha;
            -webkit-mask-image: url('images/frame-design.svg');
            -webkit-mask-mode: alpha;
            /* -webkit-mask-size: 70%;
  mask-size: 70%; */
  -webkit-mask-repeat: no-repeat;
  mask-repeat: no-repeat;
        }
    </style>
    <!--************************************
                                    Inner Banner Start
                                  *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/devils-staircase-5346794_1280.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>Tour Packages</h1>
                        <h2>Unlock Adventure: Discover the World on Wheels!</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">Tour Packages</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                                    Inner Banner End
                                  *************************************-->
    <!--************************************
                                    Main Start
                                  *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">
                        <div class="tg-listing tg-listingvtwo">
                            <div class="tg-sectiontitle">
                                <h2> Tours</h2>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                @foreach ($package as $package)
                                    <div class="col-xs-6 col-sm-4 col-md-4 col-lg-4">
                                        <div class="tg-trendingtrip">
                                            <figure>
                                                <a href="/tour-detail/{{ $package->slug }}">
                                                    <div class="mask">
                                                        <img src="{{ asset('thumbnails/' . $package->thumbnail) }}"
                                                            class="Itinerary-gat" alt="image destinations">
                                                    </div>

                                                    <div class="tg-hover">
                                                        <span class="tg-stars"><span></span></span>
                                                        <span class="tg-tourduration">{{ $package->day }} Days</span>
                                                        <span style=""
                                                            class="tg-locationname">{{ $package->day }}D/{{ $package->night }}N</span>
                                                        <div class="tg-pricearea">
                                                            <span>from</span>
                                                            <h4>${{ $package->price }} </h4>
                                                        </div>
                                                    </div>
                                                </a>
                                            </figure>
                                            <div class="tg-populartourcontent">
                                                <div class="tg-populartourtitle">
                                                    <h3><a href="/tour-detail/{{ $package->slug }}">
                                                            {{ $package->title }}
                                                        </a></h3>
                                                </div>
                                                <div class="tg-description">
                                                    <p> {!! $package->description !!} </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tg-populartourfoot">
                                            <form action="/quotation" method="post">
                                                @csrf
                                                <input name="type" type="hidden" value="pack">
                                                <input name="name" type="hidden" value=" {{ $package->title }} ">
                                                <button class="tg-btnaddtocart" type="submit"> <i
                                                        class="icon-icons240"></i>
                                                    <span>Request Quote </span></button>
                                            </form>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="clearfix"></div>
                            {{-- <nav class="tg-pagination">
									<ul>
										<li class="tg-active"><a href="javascript:void(0);">1</a></li>
										<li><a href="javascript:void(0);">2</a></li>
										<li><a href="javascript:void(0);">3</a></li>
										<li><a href="javascript:void(0);">4</a></li>
										<li class="tg-nextpage"><a href="javascript:void(0);"><i class="fa fa-angle-right"></i></a></li>
									</ul>
								</nav> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--************************************
                                    Main End
                                  *************************************-->
@endsection
